<?php
/*--------------------------------------------------------------------------------------------------
    ModifierTranslatorHelper.php 2020-02-19
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\ProductModifiers\Helpers;

class ModifierTranslatorHelper
{
    public static function translateGlobals(): void
    {
        $modifierIds = array_merge($_POST['modifiers'] ?? [], $_GET['modifiers'] ?? []);
        if(isset($modifierIds['attribute'])) {
            foreach ($modifierIds['attribute'] as $id => $value) {
                $_POST['id'][$id] = $value;
                $_GET['id'][$id] = $value;
            }
        }
        if(isset($modifierIds['property'])) {
            foreach ($modifierIds['property'] as $id => $value) {
                $_POST['properties_values_ids'][$id] = $value;
                $_GET['properties_values_ids'][$id] = $value;
            }
        }
    }
    public static function translateGET(): void
    {
        $modifierIds = $_GET['modifiers'];
    
        foreach ($modifierIds['attribute'] as $id => $value) {
            $_GET['id'][$id] = $value;
        }
    
        foreach ($modifierIds['property'] as $id => $value) {
            $_GET['properties_values_ids'][$id] = $value;
        }
    }
}